﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Xml;

namespace PI.ZB.N1200.ELearning.BL
{
    public partial class ZSBELearning : Gemini.Core.BL.Base.BusinessLogicPlugIn
    {
        private StatisticBL _StatisticBL = null;

        public StatisticBL Statistic
        {
            get
            {
                if (_StatisticBL == null)
                {
                    _StatisticBL = new StatisticBL(this);
                }

                return _StatisticBL;
            }
        }

        public class StatisticBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
        {
            public StatisticBL(ZSBELearning BL) : base(BL) { }

            public void Save(BL.ZSBELearning.ContextParam ContextParam)
            {
                if (ContextParam.Group == Dictionary.GroupType.Student)
                {
                    switch (ContextParam.CourseType)
                    {
                        case Dictionary.Category.CourseType.Case: Student.CompetencePart.SavePoints_Case(ContextParam); break;
                        case Dictionary.Category.CourseType.CompetenceCourse: Student.CompetencePart.SavePoints_Competence(ContextParam); break;
                        case Dictionary.Category.CourseType.AdvancedTest: Student.SavePoints_AdvancedTest(ContextParam); break;
                        case Dictionary.Category.CourseType.KnowledgeTest: Student.SavePoints_KnowledgeTest(ContextParam); break;
                    }
                }
            }

            #region CompetencePartStatistic
            private CompetencePartStatisticBL _CompetencePartStatisticBL = null;
            public CompetencePartStatisticBL CompetencePartStatistic
            {
                get
                {
                    if (_CompetencePartStatisticBL == null)
                    {
                        _CompetencePartStatisticBL = new CompetencePartStatisticBL(this.BLP);
                    }
                    return _CompetencePartStatisticBL;
                }
            }

            public class CompetencePartStatisticBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
            {
                public CompetencePartStatisticBL(ZSBELearning BL) : base(BL) { }

                public List<BL.BO.View.StatisticCompetencePart> Restore(BL.BO.Class Class)
                {
                    BL.BO.View.StatisticCompetencePart.Search _search = new BO.View.StatisticCompetencePart.Search();
                    _search.ClassID = Class.ID;
                    return Restore(_search);
                }

                public List<BL.BO.View.StatisticCompetencePart> Restore(BL.BO.Student Student)
                {
                    BL.BO.View.StatisticCompetencePart.Search _search = new BO.View.StatisticCompetencePart.Search();
                    _search.StudentID = Student.ID;
                    return Restore(_search);
                }

                /// <summary>
                /// Resetowanie kompetencji składowej dla studenta,
                /// ze względów optymalizacyjnych lepiej jest przekazać ID kompetencji składowej niż obiekt
                /// </summary>
                /// <param name="Student"></param>
                /// <param name="CompetencePartID"></param>
                public Gemini.Core.BL.Base.MethodResult Reset(BL.BO.Student Student, long? CompetencePartID)
                {
                    Gemini.Core.BL.Base.MethodResult _result = new Gemini.Core.BL.Base.MethodResult();
                    
                    BO.CompetencePart _CompetencePart = BLP.CompetencePart.Restore(CompetencePartID);

                    if (_CompetencePart != null && Student != null)
                    {
                        BO.Student_CompetencePart.Search _search = new BO.Student_CompetencePart.Search();
                        _search.CompetencePartID = CompetencePartID;
                        _search.StudentID = Student.ID;

                        BO.Student_CompetencePart _Student_CompetencePart = BLP.Statistic.Student.CompetencePart.RestoreTopOne(_search);

                        if (_Student_CompetencePart != null)
                        {
                            _Student_CompetencePart.AdvancedLevelID_Start = Student.CurrentAdvancedLevelID;
                            _Student_CompetencePart.EvaluationSheetID_Start = Student.CurrentEvaluationSheetID;

                            _Student_CompetencePart.AdvancedLevelID_End = null;
                            _Student_CompetencePart.EvaluationSheetID_End = null;
                            _Student_CompetencePart.CompetenceMaxPoints = null;
                            _Student_CompetencePart.CompetencePoints = null;
                            _Student_CompetencePart.CompetencePointsByWeight = null;
                            _Student_CompetencePart.CaseStudyPoints = null;
                            _Student_CompetencePart.CaseStudyMaxPoints = null;

                            _Student_CompetencePart.IsStarted = false;
                            _Student_CompetencePart.IsEnded = false;
                            _Student_CompetencePart.IsCourseDone = false;
                            _Student_CompetencePart.IsCaseDone = false;
                            _Student_CompetencePart.ResetCount = (_Student_CompetencePart.ResetCount.HasValue ? (_Student_CompetencePart.ResetCount.Value) + 1 : 1);

                            _result.Add(BLP.Statistic.Student.CompetencePart.Save(_Student_CompetencePart));

                            if (_result.Success)
                            {
                                BO.Student_CompetencePart_Solution.Search _searchSolution = new BO.Student_CompetencePart_Solution.Search();
                                _searchSolution.IsReset = false;
                                _searchSolution.StudentID = Student.ID;
                                _searchSolution.CompetencePartID = CompetencePartID;

                                List<BO.Student_CompetencePart_Solution> _listStudent_CompetencePart_Solution = BLP.Statistic.Student.CompetencePart_Solution.Restore(_searchSolution);

                                foreach (BO.Student_CompetencePart_Solution _loopStudent_CompetencePart_Solution in _listStudent_CompetencePart_Solution)
                                {
                                    _loopStudent_CompetencePart_Solution.IsReset = true;
                                    _result.Add(BLP.Statistic.Student.CompetencePart_Solution.Save(_loopStudent_CompetencePart_Solution));
                                }


                                if (_result.Success)
                                {
                                    PI.GM.N610.ELearning.BL.BO.Statistic_Course.Search _cousreStatisticSearch = new GM.N610.ELearning.BL.BO.Statistic_Course.Search();
                                    _cousreStatisticSearch.UserID = Student.UserID;
                                    _cousreStatisticSearch.CourseID = _CompetencePart.CaseID;

                                    _result.SetSuccess = BLP.BLELearning.Statistic.Course.Remove(_cousreStatisticSearch);

                                    _cousreStatisticSearch.CourseID = _CompetencePart.CompetenceCourseID;

                                    _result.SetSuccess = BLP.BLELearning.Statistic.Course.Remove(_cousreStatisticSearch);
                                }

                                _result.Add(BLP.Statistic.Student.Competence.UpdatePoints(Student, _CompetencePart));
                            }
                        }
                    }
                    else
                    {
                        _result.SetSuccess = false;
                    }

                    return _result;
                }

                /// <summary>
                /// Ze wzgledow optymalizacyjnych lepiej przekazac long? CompetenceID
                /// </summary>
                /// <param name="Student"></param>
                /// <param name="CompetenceID"></param>
                /// <returns></returns>
                public List<BL.BO.View.StatisticCompetencePart> Restore(BL.BO.Student Student, long? CompetenceID)
                {
                    BL.BO.View.StatisticCompetencePart.Search _search = new BO.View.StatisticCompetencePart.Search();
                    _search.StudentID = Student.ID;
                    _search.CompetenceID = CompetenceID;
                    return Restore(_search);
                }

                /// <summary>
                /// Ze wzgledow optymalizacyjnych lepiej przekazac long? CompetenceID
                /// </summary>
                /// <param name="Class"></param>
                /// <param name="CompetenceID"></param>
                /// <returns></returns>
                public List<BL.BO.View.StatisticCompetencePart> Restore(BL.BO.Class Class, long? CompetenceID)
                {
                    BL.BO.View.StatisticCompetencePart.Search _search = new BO.View.StatisticCompetencePart.Search();
                    _search.ClassID = Class.ID;
                    _search.CompetenceID = CompetenceID;
                    return Restore(_search);
                }

                public List<BL.BO.View.StatisticCompetencePart> Restore(BL.BO.View.StatisticCompetencePart.Search Search)
                {
                    return BLP.DAL.CompetencePartStatisticView.Restore(Search);
                }
            }
            #endregion StudentStatistic

            #region CompetenceStatistic
            private CompetenceStatisticBL _CompetenceStatisticBL = null;
            public CompetenceStatisticBL CompetenceStatistic
            {
                get
                {
                    if (_CompetenceStatisticBL == null)
                    {
                        _CompetenceStatisticBL = new CompetenceStatisticBL(this.BLP);
                    }
                    return _CompetenceStatisticBL;
                }
            }

            public class CompetenceStatisticBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
            {
                public CompetenceStatisticBL(ZSBELearning BL) : base(BL) { }

                public List<BL.BO.View.StatisticCompetence> Restore(BL.BO.Class Class)
                {
                    BL.BO.View.StatisticCompetence.Search _search = new BO.View.StatisticCompetence.Search();
                    _search.ClassID = Class.ID;
                    return Restore(_search);
                }

                public List<BL.BO.View.StatisticCompetence> Restore(BL.BO.Student Student)
                {
                    BL.BO.View.StatisticCompetence.Search _search = new BO.View.StatisticCompetence.Search();
                    _search.StudentID = Student.ID;
                    return Restore(_search);
                }

                /// <summary>
                ///  Ze wzgledow optymalizacyjnych lepiej przekazac long? CompetenceID
                /// </summary>
                /// <param name="Student"></param>
                /// <param name="CompetenceID"></param>
                /// <returns></returns>
                public List<BL.BO.View.StatisticCompetence> Restore(BL.BO.Student Student, long? CompetenceID)
                {
                    BL.BO.View.StatisticCompetence.Search _search = new BO.View.StatisticCompetence.Search();
                    _search.StudentID = Student.ID;
                    _search.CompetenceID = CompetenceID;
                    return Restore(_search);
                }

                /// <summary>
                /// Ze wzgledow optymalizacyjnych lepiej przekazac long? CompetenceID
                /// </summary>
                /// <param name="Class"></param>
                /// <param name="CompetenceID"></param>
                /// <returns></returns>
                public List<BL.BO.View.StatisticCompetence> Restore(BL.BO.Class Class, long? CompetenceID)
                {
                    BL.BO.View.StatisticCompetence.Search _search = new BO.View.StatisticCompetence.Search();
                    _search.ClassID = Class.ID;
                    _search.CompetenceID = CompetenceID;
                    return Restore(_search);
                }

                public List<BL.BO.View.StatisticCompetence> Restore(BL.BO.View.StatisticCompetence.Search Search)
                {
                    return BLP.DAL.CompetenceStatisticView.Restore(Search);
                }
            }
            #endregion StudentStatistic

            #region StudentStatistic
            private StudentStatisticBL _StudentStatisticBL = null;
            public StudentStatisticBL StudentStatistic
            {
                get
                {
                    if (_StudentStatisticBL == null)
                    {
                        _StudentStatisticBL = new StudentStatisticBL(this.BLP);
                    }
                    return _StudentStatisticBL;
                }
            }

            public class StudentStatisticBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
            {
                public StudentStatisticBL(ZSBELearning BL) : base(BL) { }

                public List<BL.BO.View.StatisticStudent> Restore(BL.BO.Instructor Instructor)
                {
                    BL.BO.View.StatisticStudent.Search _search = new BO.View.StatisticStudent.Search();
                    _search.InstructorID = Instructor.ID;
                    return Restore(_search);
                }

                public List<BL.BO.View.StatisticStudent> Restore(BL.BO.Class Class)
                {
                    BL.BO.View.StatisticStudent.Search _search = new BO.View.StatisticStudent.Search();
                    _search.ClassID = Class.ID;
                    return Restore(_search);
                }

                public List<BL.BO.View.StatisticStudent> Restore(BL.BO.Student Student)
                {
                    BL.BO.View.StatisticStudent.Search _search = new BO.View.StatisticStudent.Search();
                    _search.StudentID = Student.ID;
                    return Restore(_search);
                }

                public List<BL.BO.View.StatisticStudent> Restore(BL.BO.View.StatisticStudent.Search Search)
                {
                    return BLP.DAL.StudentStatisticView.Restore(Search);
                }
            }
            #endregion StudentStatistic

            #region AdvancedLevel
            private AdvancedLevelBL _AdvancedLevelBL = null;

            public AdvancedLevelBL AdvancedLevel
            {
                get
                {
                    if (_AdvancedLevelBL == null)
                    {
                        _AdvancedLevelBL = new AdvancedLevelBL(this.BLP);
                    }
                    return _AdvancedLevelBL;
                }
            }

            public class AdvancedLevelBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
            {
                public AdvancedLevelBL(ZSBELearning BL) : base(BL) { }

                /// <summary>
                /// Z przyczyn optymalizacyjnych jest to konieczne aby nie odzyskiwac na liscie 
                /// w statystyce wszystkich klas dodatkowo
                /// </summary>
                /// <param name="ClassID"></param>
                /// <returns></returns>
                public List<BL.BO.View.StatisticAdvancedLevel> RestoreByClassID(long? ClassID)
                {
                    BL.BO.View.StatisticAdvancedLevel.Search _search = new BO.View.StatisticAdvancedLevel.Search();
                    _search.ClassID = ClassID;
                    return Restore(_search);
                }

                public List<BL.BO.View.StatisticAdvancedLevel> Restore(BL.BO.Class Class)
                {
                    BL.BO.View.StatisticAdvancedLevel.Search _search = new BO.View.StatisticAdvancedLevel.Search();
                    _search.ClassID = Class.ID;
                    return Restore(_search);
                }

                public List<BL.BO.View.StatisticAdvancedLevel> Restore(BL.BO.Student Student)
                {
                    BL.BO.View.StatisticAdvancedLevel.Search _search = new BO.View.StatisticAdvancedLevel.Search();
                    _search.StudentID = Student.ID;
                    return Restore(_search);
                }

                /// <summary>
                /// Z przyczyn optymalizacynych lepiej przekazac long? CompetenceID zamiast obiektu
                /// </summary>
                /// <param name="Student"></param>
                /// <param name="CompetenceID"></param>
                /// <returns></returns>
                public List<BL.BO.View.StatisticAdvancedLevel> Restore(BL.BO.Student Student, long? CompetenceID)
                {
                    BL.BO.View.StatisticAdvancedLevel.Search _search = new BO.View.StatisticAdvancedLevel.Search();
                    _search.StudentID = Student.ID;
                    _search.CompetenceID = CompetenceID;
                    return Restore(_search);
                }

                /// <summary>
                /// Z przyczyn optymalizacynych lepiej przekazac long? CompetenceID oraz CompetencePartID zamiast obiektu
                /// </summary>
                /// <param name="Student"></param>
                /// <param name="CompetenceID"></param>
                /// <param name="CompetencePartID"></param>
                /// <returns></returns>
                public List<BL.BO.View.StatisticAdvancedLevel> Restore(BL.BO.Student Student, long? CompetenceID, long? CompetencePartID)
                {
                    BL.BO.View.StatisticAdvancedLevel.Search _search = new BO.View.StatisticAdvancedLevel.Search();
                    _search.StudentID = Student.ID;
                    _search.CompetenceID = CompetenceID;
                    _search.CompetencePartID = CompetencePartID;
                    return Restore(_search);
                }

                /// <summary>
                /// Z przyczyn optymalizacynych lepiej przekazac long? CompetenceID zamiast obiektu
                /// </summary>
                /// <param name="Class"></param>
                /// <param name="CompetenceID"></param>
                /// <returns></returns>
                public List<BL.BO.View.StatisticAdvancedLevel> Restore(BL.BO.Class Class, long? CompetenceID)
                {
                    BL.BO.View.StatisticAdvancedLevel.Search _search = new BO.View.StatisticAdvancedLevel.Search();
                    _search.ClassID = Class.ID;
                    _search.CompetenceID = CompetenceID;
                    return Restore(_search);
                }

                /// <summary>
                /// Z przyczyn optymalizacynych lepiej przekazac long? CompetenceID oraz CompetencePartID zamiast obiektu
                /// </summary>
                /// <param name="Class"></param>
                /// <param name="CompetenceID"></param>
                /// <returns></returns>
                public List<BL.BO.View.StatisticAdvancedLevel> Restore(BL.BO.Class Class, long? CompetenceID, long? CompetencePartID)
                {
                    BL.BO.View.StatisticAdvancedLevel.Search _search = new BO.View.StatisticAdvancedLevel.Search();
                    _search.ClassID = Class.ID;
                    _search.CompetenceID = CompetenceID;
                    _search.CompetencePartID = CompetencePartID;
                    return Restore(_search);
                }

                
                public List<BL.BO.View.StatisticAdvancedLevel> Restore(BL.BO.View.StatisticAdvancedLevel.Search Search)
                {
                    return BLP.DAL.AdvancedLevelStatisticView.Restore(Search);
                }
            }

            #endregion AdvancedLevel

            #region Student

            private StudentBL _StudentBL = null;

            public StudentBL Student
            {
                get
                {
                    if (_StudentBL == null)
                    {
                        _StudentBL = new StudentBL(this.BLP);
                    }
                    return _StudentBL;
                }
            }

            public class StudentBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
            {
                public StudentBL(ZSBELearning BL) : base(BL) { }

                public Gemini.Core.BL.Base.MethodResult UpdatePoints(BL.BO.Student Student, BL.BO.AdvancedLevel NewAdvancedLevel)
                {
                    Student.CompetenceEvaluationSheetID = null;
                    Student.CaseStudyMaxPoints = null;
                    Student.CaseStudyPoints = null;
                    Student.CompetenceMaxPoints = null;
                    Student.CompetencePointsByWeight = null;
                    Student.Salary = null;
                    Student.CompetencePartDone = 0;
                    Student.ResetCount = 0;

                    if (NewAdvancedLevel != null)
                    {
                        Student.CurrentAdvancedLevelID = NewAdvancedLevel.ID;
                    }

                    BO.Student_Competence.Search _search = new BO.Student_Competence.Search();
                    _search.StudentID = Student.ID;
                    List<BO.Student_Competence> _listStudent_Competence = BLP.DAL.Student_Competence.Restore(_search);
                    if (_listStudent_Competence.Count > 0)
                    {
                        foreach (BO.Student_Competence _loopStudent_Competence in _listStudent_Competence)
                        {
                            Student.CompetencePartDone += _loopStudent_Competence.CompetencePartDone;
                            Student.ResetCount += _loopStudent_Competence.ResetCount;

                            if (_loopStudent_Competence.CaseStudyMaxPoints.HasValue && _loopStudent_Competence.CaseStudyPoints.HasValue)
                            {
                                Student.CaseStudyMaxPoints = (Student.CaseStudyMaxPoints ?? 0) + _loopStudent_Competence.CaseStudyMaxPoints.Value;
                                Student.CaseStudyPoints = (Student.CaseStudyPoints ?? 0) + _loopStudent_Competence.CaseStudyPoints.Value;
                            }

                            if (_loopStudent_Competence.CompetenceMaxPoints.HasValue && _loopStudent_Competence.CompetencePointsByWeight.HasValue && _loopStudent_Competence.Salary.HasValue)
                            {
                                Student.CompetenceMaxPoints = (Student.CompetenceMaxPoints ?? 0) + _loopStudent_Competence.CompetenceMaxPoints.Value;
                                Student.CompetencePointsByWeight = (Student.CompetencePointsByWeight ?? 0) + _loopStudent_Competence.CompetencePointsByWeight.Value;
                                Student.Salary = (Student.Salary ?? 0) + _loopStudent_Competence.Salary.Value;
                            }
                        }
                        if (Student.CompetencePointsByWeight.HasValue && Student.CompetenceMaxPoints.HasValue)
                        {
                            Student.CompetenceEvaluationSheetID = BLP.EvaluationSheet.View.Restore(Student, Student.CompetencePointsByWeight.Value, Student.CompetenceMaxPoints.Value).ID;
                        }
                    }
                    return BLP.Student.Save(Student);
                }

                public Gemini.Core.BL.Base.MethodResult SavePoints_AdvancedTest(BL.ZSBELearning.ContextParam ContextParam)
                {
                    PI.GM.N610.ELearning.BL.BO.Statistic_Course _Statistic_Course = BLP.BLELearning.Statistic.Course.Restore(BLP.Environment.User, ContextParam.ContextObjectID, ContextParam.Course);

                    int _pointsMax = _Statistic_Course.ScoreMaxTotal.Value;
                    int _points = _Statistic_Course.ScoreTotal.Value;

                    BO.EvaluationSheet _evaluationSheet = BLP.EvaluationSheet.View.Restore(ContextParam.Class, _points, _pointsMax);

                    if (BLP.RBL.VariableRepository.GetLong(BL.Dictionary.Config.Tests.StartAdvancedTest.CourseID, BL.Dictionary.Clients.PlugIn) == ContextParam.Course.ID)
                    {
                        ContextParam.Student.AdvancedTestStartPoints = _points;
                        ContextParam.Student.AdvancedTestStartMaxPoints = _pointsMax;
                        ContextParam.Student.AdvancedTestStartEvaluationSheetID = _evaluationSheet.ID;
                    }
                    else
                    {
                        ContextParam.Student.AdvancedTestEndPoints = _points;
                        ContextParam.Student.AdvancedTestEndMaxPoints = _pointsMax;
                        ContextParam.Student.AdvancedTestEndEvaluationSheetID = _evaluationSheet.ID;
                    }

                    return UpdatePoints(ContextParam.Student,null);
                }

                public Gemini.Core.BL.Base.MethodResult SavePoints_KnowledgeTest(BL.ZSBELearning.ContextParam ContextParam)
                {
                    PI.GM.N610.ELearning.BL.BO.Statistic_Course _Statistic_Course = BLP.BLELearning.Statistic.Course.Restore(BLP.Environment.User, ContextParam.ContextObjectID, ContextParam.Course);

                    int _pointsMax = _Statistic_Course.ScoreMaxTotal.Value;
                    int _points = _Statistic_Course.ScoreTotal.Value;

                    BO.AdvancedLevel _AdvancedLevel = BLP.AdvancedLevel.Restore( _points, _pointsMax);

                    if (BLP.RBL.VariableRepository.GetLong(BL.Dictionary.Config.Tests.StartKnowledgeTest.CourseID, BL.Dictionary.Clients.PlugIn) == ContextParam.Course.ID)
                    {
                        ContextParam.Student.KnowledgeTestStartPoints = _points;
                        ContextParam.Student.KnowledgeTestStartMaxPoints = _pointsMax;
                        ContextParam.Student.KnowledgeTestStartAdvancedLevelID = _AdvancedLevel.ID;
                        ContextParam.Student.CurrentAdvancedLevelID = ContextParam.Student.KnowledgeTestStartAdvancedLevelID;
                    }
                    else
                    {
                        ContextParam.Student.KnowledgeTestEndPoints = _points;
                        ContextParam.Student.KnowledgeTestEndMaxPoints = _pointsMax;
                        ContextParam.Student.KnowledgeTestEndAdvancedLevelID = _AdvancedLevel.ID;
                    }

                    return UpdatePoints(ContextParam.Student, null);
                }

                public Gemini.Core.BL.Base.MethodResult Remove(BO.Student Student)
                {
                    Gemini.Core.BL.Base.MethodResult _MethodResult = new Gemini.Core.BL.Base.MethodResult();

                    CompetencePart_Solution.Remove(Student);
                    CompetencePart.Remove(Student);


                    return _MethodResult;
                }

                #region Student_Competence
                private CompetenceBL _CompetenceBL = null;
                public CompetenceBL Competence
                {
                    get
                    {
                        if (_CompetenceBL == null)
                        {
                            _CompetenceBL = new CompetenceBL(this.BLP);
                        }
                        return _CompetenceBL;
                    }
                }
                public class CompetenceBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
                {
                    #region Competence logic
                    public CompetenceBL(ZSBELearning BL) : base(BL) { }

                    protected BO.Student_Competence New()
                    {
                        BO.Student_Competence _Student_Competence = BLP.DAL.Student_Competence.New();
                        _Student_Competence.CaseStudyMaxPoints = null;
                        _Student_Competence.CaseStudyPoints = null;
                        _Student_Competence.CompetenceMaxPoints = null;
                        _Student_Competence.CompetencePointsByWeight = null;
                        _Student_Competence.Flags = 0;
                        _Student_Competence.IsEnded = false;
                        _Student_Competence.IsStarted = false;
                        _Student_Competence.Salary = null;
                        return _Student_Competence;
                    }

                    protected Gemini.Core.BL.Base.MethodResult Save(BO.Student_Competence Student_Competence)
                    {
                        Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                        if (Student_Competence == null)
                        {
                            _methodResult.SetSuccess = false;
                        }
                        else
                        {
                            if (Student_Competence.ID.HasValue)
                            {
                                _methodResult.SetSuccess = BLP.DAL.Student_Competence.Update(Student_Competence);
                            }
                            else
                            {
                                _methodResult.SetSuccess = BLP.DAL.Student_Competence.Create(Student_Competence);
                            }
                        }
                        return _methodResult;
                    }

                    protected Gemini.Core.BL.Base.MethodResult Remove(BO.Student_Competence Student_Competence)
                    {
                        Gemini.Core.BL.Base.MethodResult _result = new Gemini.Core.BL.Base.MethodResult(BLP.DAL.Student_Competence.Remove(Student_Competence));
                        return _result;
                    }

                    protected Gemini.Core.BL.Base.MethodResult Remove(BO.Student Student)
                    {
                        Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                        if (Student != null)
                        {
                            try
                            {
                                BO.Student_Competence.Search _search = new BO.Student_Competence.Search();
                                _search.StudentID = Student.ID;

                                _methodResult.SetSuccess = BLP.DAL.Student_Competence.Remove(_search);

                                if (!_methodResult.Success)
                                {
                                    _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Failed.Value, false);
                                }
                            }
                            catch (Exception _exception)
                            {
                                _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Exception.Value, _exception);
                            }
                        }
                        return _methodResult;
                    }

                    protected int Count()
                    {
                        return BLP.DAL.Student_Competence.Count();
                    }


                    public Gemini.Core.BL.Base.MethodResult UpdatePoints(BO.Student Student, BO.CompetencePart CompetencePart)
                    {
                        BO.Competence _competence = BLP.Competence.Restore(CompetencePart);

                        return UpdatePoints(Student, _competence, null);
                    }

                    public Gemini.Core.BL.Base.MethodResult UpdatePoints(BO.Student Student,BO.Competence Competence, BL.BO.AdvancedLevel NewAdvancedLevel)
                    {
                        BO.Student_CompetencePart.Search _searchPart = new BO.Student_CompetencePart.Search();
                        _searchPart.CompetenceID = Competence.ID;
                        _searchPart.StudentID = Student.ID;
                        List<BO.Student_CompetencePart> _listStudent_CompetencePart = BLP.DAL.Student_CompetencePart.Restore(_searchPart);

                        BO.Student_Competence.Search _search = new BO.Student_Competence.Search();
                        _search.CompetenceID = Competence.ID;
                        _search.StudentID = Student.ID;

                        BO.Student_Competence _Student_Competence = BLP.DAL.Student_Competence.RestoreTopOne(_search);

                        if (_Student_Competence == null)
                        {
                            _Student_Competence = New();
                            _Student_Competence.CompetenceID = Competence.ID;
                            _Student_Competence.StudentID = Student.ID;
                        }

                        _Student_Competence.IsEnded                     = true;
                        _Student_Competence.IsStarted                   = true;
                        _Student_Competence.CompetenceEvaluationSheetID = null;
                        _Student_Competence.CompetenceMaxPoints         = null;
                        _Student_Competence.CompetencePointsByWeight    = null;
                        _Student_Competence.Salary                      = null;
                        _Student_Competence.CaseStudyMaxPoints          = null;
                        _Student_Competence.CaseStudyPoints             = null;
                        _Student_Competence.CompetencePartDone          = 0;
                        _Student_Competence.ResetCount                  = 0;

                        if (_listStudent_CompetencePart.Count > 0)
                        {
                            foreach (BO.Student_CompetencePart _loopStudent_CompetencePart in _listStudent_CompetencePart)
                            {
                                _Student_Competence.IsEnded &= _loopStudent_CompetencePart.IsEnded.Value;
                                _Student_Competence.IsStarted &= _loopStudent_CompetencePart.IsStarted.Value;

                                _Student_Competence.CompetencePartDone += (_loopStudent_CompetencePart.IsEnded == true ? 1 : 0);
                                _Student_Competence.ResetCount += _loopStudent_CompetencePart.ResetCount ?? 0;

                                if (_loopStudent_CompetencePart.CompetenceMaxPoints.HasValue && _loopStudent_CompetencePart.CompetencePointsByWeight.HasValue && _loopStudent_CompetencePart.Salary.HasValue)
                                {
                                    _Student_Competence.CompetenceMaxPoints = (_Student_Competence.CompetenceMaxPoints ?? 0) + _loopStudent_CompetencePart.CompetenceMaxPoints.Value;
                                    _Student_Competence.CompetencePointsByWeight = (_Student_Competence.CompetencePointsByWeight ?? 0) + _loopStudent_CompetencePart.CompetencePointsByWeight.Value;
                                    _Student_Competence.Salary = (_Student_Competence.Salary ?? 0) + _loopStudent_CompetencePart.Salary.Value;
                                }

                                if (_loopStudent_CompetencePart.CaseStudyMaxPoints.HasValue && _loopStudent_CompetencePart.CaseStudyPoints.HasValue)
                                {
                                    _Student_Competence.CaseStudyMaxPoints = (_Student_Competence.CaseStudyMaxPoints ?? 0) + _loopStudent_CompetencePart.CaseStudyMaxPoints.Value;
                                    _Student_Competence.CaseStudyPoints = (_Student_Competence.CaseStudyPoints ?? 0) + _loopStudent_CompetencePart.CaseStudyPoints.Value;
                                }
                            }

                            if (_Student_Competence.CompetencePointsByWeight.HasValue && _Student_Competence.CompetenceMaxPoints.HasValue)
                            {
                                _Student_Competence.CompetenceEvaluationSheetID = BLP.EvaluationSheet.View.Restore(Student, _Student_Competence.CompetencePointsByWeight.Value, _Student_Competence.CompetenceMaxPoints.Value).ID;
                            }
                        }

                        Gemini.Core.BL.Base.MethodResult _result = Save(_Student_Competence);
                        _result.Add(BLP.Statistic.Student.UpdatePoints(Student, NewAdvancedLevel));
                        return _result;
                    }

                    public List<BO.Student_Competence> Restore(BL.BO.Student Student)
                    {
                        BO.Student_Competence.Search _search = new BO.Student_Competence.Search();
                        _search.StudentID = Student.ID;
                        return BLP.DAL.Student_Competence.Restore(_search);
                    }

                    public BO.Student_Competence Restore(BO.Student Student, BO.Competence Competence)
                    {
                        BO.Student_Competence.Search _search = new BO.Student_Competence.Search();
                        _search.StudentID = Student.ID;
                        _search.CompetenceID = Competence.ID;
                        List<BO.Student_Competence> _listStudent_Competence = BLP.DAL.Student_Competence.Restore(_search);
                        return _listStudent_Competence.Count > 0 ? _listStudent_Competence[0] : null;
                    }
                    #endregion
                }
                #endregion

                #region Competence Part
                private CompetencePartBL _CompetencePartBL = null;
                public CompetencePartBL CompetencePart
                {
                    get
                    {
                        if (_CompetencePartBL == null)
                        {
                            _CompetencePartBL = new CompetencePartBL(this.BLP);
                        }
                        return _CompetencePartBL;
                    }
                }

                public class CompetencePartBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
                {
                    internal protected CompetencePartBL(ZSBELearning BL) : base(BL) { }

                    protected BO.Student_CompetencePart New()
                    {
                        BO.Student_CompetencePart _Student_CompetencePart = BLP.DAL.Student_CompetencePart.New();
                        _Student_CompetencePart.CaseStudyMaxPoints = null;
                        _Student_CompetencePart.CaseStudyPoints = null;
                        _Student_CompetencePart.CompetenceMaxPoints = null;
                        _Student_CompetencePart.CompetencePoints = null;
                        _Student_CompetencePart.CompetencePointsByWeight = null;
                        _Student_CompetencePart.IsEnded = false;
                        _Student_CompetencePart.IsStarted = false;
                        _Student_CompetencePart.ResetCount = 0;
                        _Student_CompetencePart.Salary = null;
                        return _Student_CompetencePart;
                    }

                    protected Gemini.Core.BL.Base.MethodResult Remove(BO.Student_CompetencePart Student_CompetencePart)
                    {
                        Gemini.Core.BL.Base.MethodResult _result = new Gemini.Core.BL.Base.MethodResult(BLP.DAL.Student_CompetencePart.Remove(Student_CompetencePart));
                        return _result;
                    }

                    public BO.Student_CompetencePart Restore(BL.ZSBELearning.ContextParam ContextParam)
                    {
                        BO.Student_CompetencePart.Search _search = new BO.Student_CompetencePart.Search();
                        _search.StudentID = ContextParam.Student.ID;
                        _search.CompetencePartID = ContextParam.CompetencePart.ID;
                        _search.CompetenceID = ContextParam.Competence.ID;

                        return BLP.DAL.Student_CompetencePart.RestoreTopOne(_search);
                    }

                    internal Gemini.Core.BL.Base.MethodResult Remove(BO.Student Student)
                    {
                        Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                        if (Student != null)
                        {
                            try
                            {
                                BO.Student_CompetencePart.Search _search = new BO.Student_CompetencePart.Search();
                                _search.StudentID = Student.ID;

                                _methodResult.SetSuccess = BLP.DAL.Student_CompetencePart.Remove(_search);

                                if (!_methodResult.Success)
                                {
                                    _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Failed.Value, false);
                                }
                            }
                            catch (Exception _exception)
                            {
                                _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Exception.Value, _exception);
                            }
                        }
                        return _methodResult;
                    }

                    protected int Count()
                    {
                        return BLP.DAL.Student_CompetencePart.Count();
                    }

                    public List<BO.Student_CompetencePart> Restore(BO.Student_CompetencePart.Search Search)
                    {
                        return BLP.DAL.Student_CompetencePart.Restore(Search);
                    }


                    public BO.Student_CompetencePart RestoreTopOne(BO.Student_CompetencePart.Search Search)
                    {
                        return BLP.DAL.Student_CompetencePart.RestoreTopOne(Search);
                    }

                    public Gemini.Core.BL.Base.MethodResult Save(BO.Student_CompetencePart Student_CompetencePart)
                    {
                        Gemini.Core.BL.Base.MethodResult _MethodResult = new Gemini.Core.BL.Base.MethodResult();
                        try
                        {
                            if (Student_CompetencePart.ID.HasValue)
                            {
                                _MethodResult.SetSuccess = BLP.DAL.Student_CompetencePart.Update(Student_CompetencePart);
                            }
                            else
                            {
                                _MethodResult.SetSuccess = BLP.DAL.Student_CompetencePart.Create(Student_CompetencePart);
                            }
                        }
                        catch (Exception _exception)
                        {
                            _MethodResult.Add(_exception);
                        }

                        return _MethodResult;
                    }

                    public Gemini.Core.BL.Base.MethodResult SavePoints_Competence(BL.ZSBELearning.ContextParam ContextParam)
                    {
                        Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                        if (ContextParam.CompetencePart != null && ContextParam.Student != null)
                        {
                            try
                            {
                                PI.GM.N610.ELearning.BL.BO.Statistic_Course _Statistic_Course = BLP.BLELearning.Statistic.Course.Restore(BLP.Environment.User, ContextParam.ContextObjectID, ContextParam.Course);

                                int _pointsMax = _Statistic_Course.ScoreMaxTotal.Value;
                                int _points = _Statistic_Course.ScoreTotal.Value;

                                BO.EvaluationSheet _evaluationSheet = BLP.EvaluationSheet.View.Restore(ContextParam.Class, (int)(_points * ContextParam.AdvancedLevel.PointsWeight), _pointsMax);
                                BO.AdvancedLevel _newAdvancedLevel = BLP.AdvancedLevel.Restore(_points, _pointsMax);

                                #region Student_CompetencePart_Solution
                                BO.Student_CompetencePart_Solution _Student_CompetencePart_Solution = BLP.Statistic.Student.CompetencePart_Solution.Restore(ContextParam);

                                if (_Student_CompetencePart_Solution == null)
                                {
                                    _Student_CompetencePart_Solution = BLP.Statistic.Student.CompetencePart_Solution.New();
                                    _Student_CompetencePart_Solution.Flags = BO.Student_CompetencePart_Solution.FlagsType.None;
                                    _Student_CompetencePart_Solution.StudentID = ContextParam.Student.ID;
                                    _Student_CompetencePart_Solution.AdvancedLevelID_Start = ContextParam.AdvancedLevel.ID;
                                    _Student_CompetencePart_Solution.EvaluationSheetID_Start = ContextParam.EvaluationSheet.ID;
                                    _Student_CompetencePart_Solution.IsReset = false;
                                }

                                _Student_CompetencePart_Solution.Flags = BO.Student_CompetencePart_Solution.FlagsType.IsCourseDone;
                                _Student_CompetencePart_Solution.AdvancedLevelID_End = _newAdvancedLevel.ID;
                                _Student_CompetencePart_Solution.EvaluationSheetID_End = _evaluationSheet.ID;
                                _Student_CompetencePart_Solution.CompetenceID = ContextParam.Competence.ID;
                                _Student_CompetencePart_Solution.CompetenceMaxPoints = _pointsMax;
                                _Student_CompetencePart_Solution.CompetencePartID = ContextParam.CompetencePart.ID;
                                _Student_CompetencePart_Solution.CompetencePoints = _points;
                                _Student_CompetencePart_Solution.CompetencePointsByWeight = (int?)(ContextParam.AdvancedLevel.PointsWeight * _points);
    
                                _methodResult.Add(BLP.Statistic.Student.CompetencePart_Solution.Save(_Student_CompetencePart_Solution));
                                #endregion

                                #region Student_CompetencePart
                                BO.Student_CompetencePart _Student_CompetencePart = Restore(ContextParam);

                                if (_Student_CompetencePart == null)
                                {
                                    _Student_CompetencePart = New();
                                    _Student_CompetencePart.StudentID = ContextParam.Student.ID;
                                    _Student_CompetencePart.ResetCount = 0;
                                    _Student_CompetencePart.Flags = 0;
                                    _Student_CompetencePart.IsStarted = true;
                                    _Student_CompetencePart.IsEnded = false;
                                    _Student_CompetencePart.CompetenceID = ContextParam.Competence.ID;
                                    _Student_CompetencePart.CompetencePartID = ContextParam.CompetencePart.ID;
                                    _Student_CompetencePart.AdvancedLevelID_Start = ContextParam.AdvancedLevel.ID;
                                    _Student_CompetencePart.EvaluationSheetID_Start = ContextParam.EvaluationSheet.ID;
                                }

                                _Student_CompetencePart.IsCourseDone = true;
                                _Student_CompetencePart.AdvancedLevelID_End = _newAdvancedLevel.ID;
                                _Student_CompetencePart.EvaluationSheetID_End = _evaluationSheet.ID;
                                _Student_CompetencePart.CompetenceMaxPoints = _pointsMax;
                                _Student_CompetencePart.CompetencePoints = _points;
                                _Student_CompetencePart.CompetencePointsByWeight = (int?)(ContextParam.AdvancedLevel.PointsWeight * _points);

                                _Student_CompetencePart.IsEnded = _Student_CompetencePart.CompetencePoints != null && _Student_CompetencePart.CaseStudyPoints != null;

                                if (!_Student_CompetencePart.Salary.HasValue)
                                {
                                    _Student_CompetencePart.Salary = (decimal?)ContextParam.AdvancedLevel.SalaryWeight * ContextParam.EvaluationSheet.Salary;
                                }

                                _methodResult.Add(BLP.Statistic.Student.CompetencePart.Save(_Student_CompetencePart));
                                #endregion

                                ContextParam.Student.CurrentEvaluationSheetID = _evaluationSheet.ID;

                                _methodResult.Add(BLP.Statistic.Student.Competence.UpdatePoints(ContextParam.Student,ContextParam.Competence, _newAdvancedLevel));
                            }
                            catch (Exception _exception)
                            {
                                _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Exception.Value, _exception);
                            }
                        }
                        return _methodResult;
                    }

                    public Gemini.Core.BL.Base.MethodResult SavePoints_Case(BL.ZSBELearning.ContextParam ContextParam)
                    {
                        Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                        if (ContextParam.CompetencePart != null && ContextParam.Student != null)
                        {
                            try
                            {
                                int _pointsMax = ContextParam.Units.Count;
                                int _points = BLP.Course.CountExerciseMaxPointDone(ContextParam);

                                #region Student_CompetencePart_Solution
                                BO.Student_CompetencePart_Solution _Student_CompetencePart_Solution = BLP.Statistic.Student.CompetencePart_Solution.Restore(ContextParam);

                                if (_Student_CompetencePart_Solution == null)
                                {
                                    _Student_CompetencePart_Solution = BLP.Statistic.Student.CompetencePart_Solution.New();
                                    _Student_CompetencePart_Solution.Flags = BO.Student_CompetencePart_Solution.FlagsType.None;
                                    _Student_CompetencePart_Solution.StudentID = ContextParam.Student.ID;
                                    _Student_CompetencePart_Solution.AdvancedLevelID_Start = ContextParam.AdvancedLevel.ID;
                                    _Student_CompetencePart_Solution.EvaluationSheetID_Start = ContextParam.EvaluationSheet.ID;
                                    _Student_CompetencePart_Solution.IsReset = false;
                                }

                                _Student_CompetencePart_Solution.Flags = BO.Student_CompetencePart_Solution.FlagsType.IsCaseDone;
                                _Student_CompetencePart_Solution.CaseStudyMaxPoints = _points;
                                _Student_CompetencePart_Solution.CaseStudyPoints = _pointsMax;

                                _methodResult.Add(BLP.Statistic.Student.CompetencePart_Solution.Save(_Student_CompetencePart_Solution));
                                #endregion

                                #region Student_CompetencePart
                                BO.Student_CompetencePart _Student_CompetencePart = Restore(ContextParam);

                                if (_Student_CompetencePart == null)
                                {
                                    _Student_CompetencePart = New();
                                    _Student_CompetencePart.StudentID = ContextParam.Student.ID;
                                    _Student_CompetencePart.ResetCount = 0;
                                    _Student_CompetencePart.Flags = BO.Student_CompetencePart.FlagsType.None;
                                    _Student_CompetencePart.IsStarted = true;

                                    _Student_CompetencePart.CompetenceID = ContextParam.Competence.ID;
                                    _Student_CompetencePart.CompetencePartID = ContextParam.CompetencePart.ID;
                                    _Student_CompetencePart.AdvancedLevelID_Start = ContextParam.AdvancedLevel.ID;
                                    _Student_CompetencePart.EvaluationSheetID_Start = ContextParam.EvaluationSheet.ID;
                                }
                                _Student_CompetencePart.IsCaseDone = true;
                                _Student_CompetencePart.CaseStudyMaxPoints = _pointsMax;
                                _Student_CompetencePart.CaseStudyPoints = _points;
                                _Student_CompetencePart.IsEnded = _Student_CompetencePart.CompetencePoints != null && _Student_CompetencePart.CaseStudyPoints != null;

                                // zapis Competence part
                                _methodResult.Add(Save(_Student_CompetencePart));
                                #endregion

                                // aktualizacja competence
                                _methodResult.Add(BLP.Statistic.Student.Competence.UpdatePoints(ContextParam.Student, ContextParam.Competence, null));
                            }
                            catch (Exception _exception)
                            {
                                _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Exception.Value, _exception);
                            }
                        }
                        return _methodResult;
                    }

                    public Gemini.Core.BL.Base.MethodResult SaveLoad(BL.ZSBELearning.ContextParam ContextParam)
                    {
                        Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                        try
                        {
                            BO.Student_CompetencePart _Student_CompetencePart = Restore(ContextParam);

                            if (_Student_CompetencePart == null)
                            {
                                _Student_CompetencePart = New();
                                _Student_CompetencePart.StudentID = ContextParam.Student.ID;
                                _Student_CompetencePart.ResetCount = 0;
                                _Student_CompetencePart.Flags = 0;
                                _Student_CompetencePart.IsStarted = true;
                                _Student_CompetencePart.IsEnded = false;
                                _Student_CompetencePart.CompetenceID = ContextParam.Competence.ID;
                                _Student_CompetencePart.CompetencePartID = ContextParam.CompetencePart.ID;
                                _Student_CompetencePart.AdvancedLevelID_Start = ContextParam.AdvancedLevel.ID;
                                _Student_CompetencePart.EvaluationSheetID_Start = ContextParam.EvaluationSheet.ID;

                                _methodResult.Add(Save(_Student_CompetencePart));
                            }
                            else if (_Student_CompetencePart.IsStarted == false)
                            {
                                _Student_CompetencePart.IsStarted = true;
                                _Student_CompetencePart.CompetenceID = ContextParam.Competence.ID;
                                _Student_CompetencePart.CompetencePartID = ContextParam.CompetencePart.ID;
                                _Student_CompetencePart.AdvancedLevelID_Start = ContextParam.AdvancedLevel.ID;
                                _Student_CompetencePart.EvaluationSheetID_Start = ContextParam.EvaluationSheet.ID;

                                _methodResult.Add(Save(_Student_CompetencePart));
                            }
                        }
                        catch (Exception _exception)
                        {
                            _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Exception.Value, _exception);
                        }

                        return _methodResult;
                    }
                }

                #endregion

                #region CompetencePart_Solution
                private CompetencePart_SolutionBL _CompetencePart_SolutionBL = null;
                internal CompetencePart_SolutionBL CompetencePart_Solution
                {
                    get
                    {
                        if (_CompetencePart_SolutionBL == null)
                        {
                            _CompetencePart_SolutionBL = new CompetencePart_SolutionBL(this.BLP);
                        }
                        return _CompetencePart_SolutionBL;
                    }
                }
                internal class CompetencePart_SolutionBL : Gemini.Core.BL.Base.BusinessLogicPlugInClass<ZSBELearning>
                {
                    public CompetencePart_SolutionBL(ZSBELearning BL) : base(BL) { }

                    public BO.Student_CompetencePart_Solution New()
                    {
                        return BLP.DAL.Student_CompetencePart_Solution.New();
                    }

                    public BO.Student_CompetencePart_Solution RestoreTopOne(BO.Student_CompetencePart_Solution.Search Search)
                    {
                        return BLP.DAL.Student_CompetencePart_Solution.RestoreTopOne(Search);
                    }

                    public BO.Student_CompetencePart_Solution Restore(BL.ZSBELearning.ContextParam ContextParam)
                    {
                        BO.Student_CompetencePart_Solution.Search _searchSolution = new BO.Student_CompetencePart_Solution.Search();
                        _searchSolution.StudentID = ContextParam.Student.ID;
                        _searchSolution.CompetenceID = ContextParam.Competence.ID;
                        _searchSolution.CompetencePartID = ContextParam.CompetencePart.ID;
                        _searchSolution.IsReset = false;

                        return BLP.DAL.Student_CompetencePart_Solution.RestoreTopOne(_searchSolution);
                    }

                    public List<BO.Student_CompetencePart_Solution> Restore(BO.Student_CompetencePart_Solution.Search Search)
                    {
                        return BLP.DAL.Student_CompetencePart_Solution.Restore(Search);
                    }

                    public Gemini.Core.BL.Base.MethodResult Save(BO.Student_CompetencePart_Solution Student_CompetencePart_Solution)
                    {
                        Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                        if (Student_CompetencePart_Solution == null)
                        {
                            _methodResult.SetSuccess = false;
                        }
                        else
                        {
                            if (Student_CompetencePart_Solution.ID.HasValue)
                            {
                                _methodResult.SetSuccess = BLP.DAL.Student_CompetencePart_Solution.Update(Student_CompetencePart_Solution);
                            }
                            else
                            {
                                _methodResult.SetSuccess = BLP.DAL.Student_CompetencePart_Solution.Create(Student_CompetencePart_Solution);
                            }
                        }
                        return _methodResult;
                    }

                    public Gemini.Core.BL.Base.MethodResult Remove(BO.Student_CompetencePart_Solution Student_CompetencePart_Solution)
                    {
                        Gemini.Core.BL.Base.MethodResult _result = new Gemini.Core.BL.Base.MethodResult(BLP.DAL.Student_CompetencePart_Solution.Remove(Student_CompetencePart_Solution));
                        return _result;
                    }

                    public Gemini.Core.BL.Base.MethodResult Remove(BO.Student Student)
                    {
                        Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

                        if (Student != null)
                        {
                            try
                            {
                                BO.Student_CompetencePart_Solution.Search _search = new BO.Student_CompetencePart_Solution.Search();
                                _search.StudentID = Student.ID;

                                _methodResult.SetSuccess = BLP.DAL.Student_CompetencePart_Solution.Remove(_search);

                                if (!_methodResult.Success)
                                {
                                    _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Failed.Value, false);
                                }
                            }
                            catch (Exception _exception)
                            {
                                _methodResult.Add(Gemini.Dictionary.Text.RemoveEvents.Exception.Value, _exception);
                            }
                        }
                        return _methodResult;
                    }

                    public int Count()
                    {
                        return BLP.DAL.Student_CompetencePart_Solution.Count();
                    }
                }
                #endregion
            }
            #endregion Student
        }
    }
}